--[[
Dieses Skript testet alle Funktionen aus dem Namensraum 'str'.
]]


do
	assert(str.arg("The number is: %1",  {4.5666, 0, "f", 2} )=="The number is: 4.57");
	assert(str.arg("%1|test|%2|%3|%4|%1",  { {"AB"}, {4.5666, 0, "f", 2}, {33,-10,10,'x'}, {"Chicken"} } )=="AB|test|4.57|33xxxxxxxx|Chicken|AB");
	assert(str.arg("%1", {1.23456789, 0, 'f', -1}) == "1.23456789");
	assert(str.arg("%1", {1.23556789, 0, 'f', 2}) == "1.24");
end

do
	local s="1234567890";
	assert(str.chopped(s, 1)=="123456789");
end

do
	assert(str.compare("A", "A", 1, 1)==0);
	assert(str.compare("A", "B", 1, 1)==-1);
	assert(str.compare(1.255551, 1.255552, 1, 1, 2)==0);
	assert(str.compare(1.255551, 1.255552, 1, 1, 6)==-1);
	assert(str.compare_num(1.255551, 1.255552)==0);
	assert(str.compare_num(1.255551, 1.255552, 6)==-1);
	assert(str.compare_num(100000000000000, 100000000000001)==-1);
end

do
	assert(str.contains("123äöüß", "ß"));
	assert(str.contains(1234567890, 567890));
	assert(not str.contains("123äöü321", "Äö"));
	assert(str.contains("123äöü321", "Äö", false));
	assert(str.contains("123äöü321", "äö"));
	assert(not str.contains("123äöü321", "äö4", false));
end

do
	local find="(\\+|-)?[[:digit:]]+"; --integer
	assert(str.contains_regex(1234567890, find, str.REGEX_MATCH));
	assert(str.contains_regex(1234567890, find, str.REGEX_FIND));
	
	find="^[a-zA-Z0-9]+(?:\\.[a-zA-Z0-9]+)*@[a-zA-Z0-9]+(?:\\.[a-zA-Z0-9]+)*$"; --email ohne umlaute
	assert(str.contains_regex("info@str.net", find, str.REGEX_MATCH));
	assert(not str.contains_regex(" info@str.net ", find, str.REGEX_MATCH));
	assert(str.contains_regex("info@str.net", find, str.REGEX_FIND));
	assert(not str.contains_regex("info.str.net", find, str.REGEX_FIND));
	assert(not str.contains_regex("1@taxpül.net", find, str.REGEX_FIND));
end

do
	local find="Rechnung{and}M{*}ller{;}Rechnung{and}Meier";
	assert(str.contains_regex_wild("MüllerRechnung", find, str.REGEX_EXT |str.REGEX_MATCH));
	assert(str.contains_regex_wild("MüllerRechnung", find, str.REGEX_EXT |str.REGEX_FIND));
	assert(not str.contains_regex_wild("NurRechnung", find, str.REGEX_EXT|str.REGEX_FIND));
	local text="meineFirma.DBB"
	assert(str.contains_regex_wild(text, "*.dbb", str.REGEX_MATCH|str.REGEX_ICASE));
	assert(str.contains_regex_wild(text, "*.dbb", str.REGEX_FIND |str.REGEX_ICASE));
	assert(not str.contains_regex_wild(text, "*.dbb", str.REGEX_MATCH));
	assert(not str.contains_regex_wild(text, "*.dbb", str.REGEX_FIND));
	text="123meineFirma.DBB";
	assert(not str.contains_regex_wild(text, "m*.dbb", str.REGEX_MATCH|str.REGEX_ICASE));
	assert(str.contains_regex_wild(text, "m*.dbb", str.REGEX_FIND|str.REGEX_ICASE));
end


do
	assert(str.count("1112345123451", 1)==5);
	assert(str.count("äöüääää", "Ä", false)==5);
	assert(str.count("äöüääää", "Ä")==0);
end

do
	assert(not str.endsWith("auto.Tüv", "tüv"));
	assert(str.endsWith("auto.Tüv", "tüv", false));
	assert(not str.endsWith("auto.Tüv", "tü", false));
end

do
	local t={{"cX", 3, "X", 4}, {"cX", 7, "X", 8}, {"cX", 11, "X", 12}};
	
	assert(str.compare_table(
	str.find_regex("abcXabcXabcX", "c(X)"), t
	));
	
	assert(not str.compare_table( -- x lowercase
	str.find_regex("abcXabcXabcX", "c(x)"), t
	));
	
	assert(str.compare_table( -- icase active
	str.find_regex("abcXabcXabcX", "c(x)", str.REGEX_ICASE|str.REGEX_RET_ALL), t
	));
	
	assert(str.compare_table( -- icase active, return only captures
	str.find_regex("abcXabcXabcX", "c(x)", str.REGEX_ICASE|str.REGEX_RET_CAPTURE), {"X", "X", "X"}
	));
	
	assert(
	str.find_regex("123rtzäÖÜ3ß", "([a-zA-ZäöüÄÖÜß]+)", str.REGEX_ICASE|str.REGEX_RET_CAPTURE|str.REGEX_RET_AS_STRING)=="rtzäÖÜ"
	);
	
	assert(
	str.find_regex("123rtzäÖÜ3ß", "[a-zA-ZäöüÄÖÜß]+", str.REGEX_ICASE|str.REGEX_RET_MATCH|str.REGEX_RET_AS_STRING)=="rtzäÖÜ"
	);
	
	assert(
	str.find_regex("123rtzäÖÜ3ß", "([a-zA-ZäöüÄÖÜß]+)", str.REGEX_ICASE|str.REGEX_RET_CAPTURE|str.REGEX_RET_AS_STRING|str.REGEX_RET_COMBINED)=="rtzäÖÜß"
	);
	
	assert(
	str.find_regex("Bank-1024", "\\d+", str.REGEX_RET_MATCH|str.REGEX_RET_AS_STRING)=="1024"
	);
	
end

do
	assert(string.find("abäöü", "ü")==7); --number of utf-8-bytes
	assert(str.indexOf("abäöü", "öü", 1)==4); --number of chars

	local s="TextÄöüß";
	assert(str.indexOf(s, "öü", 1)==6);
	local i,j=str.indexOf(s, "öü");
	assert(str.mid(s, i, j-i+1)=="öü");
	
	local x = "sticky question";
	local y = "sti";
	assert(str.indexOf(x, y) == 1);               
	assert(str.indexOf(x, y, 2) == 11);            
	assert(str.indexOf(x, y, 11) == 11);            
	assert(str.indexOf(x, y, 12) == nil);           

	y = "Sti";
	assert(str.indexOf(x, y) == nil);
	assert(str.indexOf(x, y, 2, false) == 11);

	assert(str.indexOf(x, "") == 1);
	assert(str.indexOf("", y) == nil);
	assert(str.indexOf("", "") == 1);
end

do
	assert(str.insert(1, "1234567890", "x")=="x1234567890");
	assert(str.insert(2, "1234567890", "x")=="1x234567890");
	assert(str.insert(-1, "1234567890", "x")=="1234567890");
	assert(str.insert(20, "1234567890", "x")=="1234567890         x");
end

do
	local x = "crazy azimuths";
	local y = "az";
	assert(str.lastIndexOf(x, y) == 7);         
	assert(str.lastIndexOf(x, y, 7) == 7);       
	assert(str.lastIndexOf(x, y, 6) == 3);      
	assert(str.lastIndexOf(x, y, 2) == nil);        

	y = "Az";
	assert(str.lastIndexOf(x, y) == nil);
	assert(str.lastIndexOf(x, y, 7, false) == 7);

	assert(str.lastIndexOf(x, "") == str.length(x)+1);
	assert(str.lastIndexOf(x, "", 5) == 5);
	assert(str.lastIndexOf(x, "", str.length(x)+1) == str.length(x)+1);
	assert(str.lastIndexOf(x, "", 25) == nil);
	assert(str.lastIndexOf("", y) == nil);
	assert(str.lastIndexOf("", "") == 1);
end

do
	assert(str.left("1234", 3)=="123");
end

do
	assert(str.length(1.3456789)==9);
end

do
	assert(str.mid("1234567890", 5, 2)=="56");
	assert(str.mid("1234567890", 5)=="567890");
	assert(str.mid("1234567890", 5, -1)=="567890");
end

do
	assert(str.remove("1234567890", 5, 3)=="1234890");
	assert(str.remove("1234567890", -1, 3)=="1234567890");
	assert(str.remove("1234567890", 3, 20)=="12");
	assert(str.remove("12345678901234567890", "890")=="12345671234567");
	assert(str.remove("ä12345678901234567890ä", "Ä")=="ä12345678901234567890ä");
	assert(str.remove("ä12345678901234567890ä", "Ä", false)=="12345678901234567890");
	assert(str.remove("ä12345678901234567890ä", "ä")=="12345678901234567890");
end

do
	assert(str.replace("1234567890", 5, 3, "ABC")=="1234ABC890");
	assert(str.replace("1234567890", -1, 3, "ABC")=="1234567890");
	assert(str.replace("12345678901234567890", "0", "abc")=="123456789abc123456789abc");
	assert(str.replace("ä12345678901234567890ä", "Ä", "abc")=="ä12345678901234567890ä");
	assert(str.replace("ä12345678901234567890ä", "Ä", "abc", false)=="abc12345678901234567890abc");
	assert(str.replace("ä12345678901234567890ä", "ä", "abc")=="abc12345678901234567890abc");
end

do
	assert(str.replace_regex("Quick brown fox","a|e|i|o|u", "*")=="Q**ck br*wn f*x");
	assert(str.replace_regex("Quick brown fox","Qu?", "S", str.REGEX_WILDCASE)=="Sick brown fox");
	
	--with captures
	assert(str.replace_regex("sunflowers, sunburn, sunshine","(sun)(.*)", "$1")=="sun");
	assert(str.replace_regex("Beleg-125","[^0-9]*([0-9]+).*", "$1")=="125");
end

do
	assert(str.right("1234567890", 3)=="890");
end

do
	assert(not str.startsWith("auto.tüv", "AUTO."));
	assert(str.startsWith("auto.tüv", "AUTO.", false));
	assert(str.startsWith("auto.tüv", "auto."));
	assert(not str.endsWith("auto.tüv", "uto", false));
end

do
	local s="TextÄöüß";
	assert(str.toLower(s)=="textäöüß");
	assert(str.toUpper(s)=="TEXTÄÖÜß");
end

do
	assert(str.trimmed("\r\n\t\"\'123     \t\t\f\v")=="\"\'123");
	assert(str.trimmed("  1234567890\r\n  ", " ")=="1234567890\r\n");
	assert(str.trimmed("  1234567890\r\n  ", " ", str.TRIM_ALL)=="1234567890\r\n");
	assert(str.trimmed("  1234567890\r\n  ", " ", str.TRIM_LEFT)=="1234567890\r\n  ");
	assert(str.trimmed("  1234567890\r\n  ", " ", str.TRIM_RIGHT)=="  1234567890\r\n");
	assert(str.trimmed("  1234567890\r\n  ", "", str.TRIM_ALL)=="1234567890");
	assert(str.trimmed("  1234567890\r\n  ", "", str.TRIM_LEFT)=="1234567890\r\n  ");
	assert(str.trimmed("  1234567890\r\n  ", "", str.TRIM_RIGHT)=="  1234567890");
end

taxpool.message_box("Test passed.", taxpool.DLG_INFO);



















