--[[
Dies ist ein Beispielskript zum Importieren von JTL-WAWI-Ameise-Buchungsdaten (z.B. die beiliegende Datei 'import-jtl.tsv').
Bitte importieren Sie die Beispiel-Daten nicht in eine bestehende Buchhaltung, sondern legen Sie zum Testen der Funktionen eine separate Buchhaltungsdatei an. 
]]

if taxpool.message_box("Bei diesem Beispiel werden Daten aus einer Textdatei importiert.\nDas Beispiel sollte nur mit einer Testbuchhaltung ausgeführt werden\nWollen Sie den Vorgang wirklich fortsetzen?", 
					   taxpool.DLG_YES|taxpool.DLG_NO|taxpool.DLG_QUESTION)==taxpool.DLG_NO then
return
end

taxpool.start_transaction(1)

--Einstellungsdialog oeffnen
local res, filename, delim, has_fieldnames, is_utf8=taxpool.get_options(taxpool.CONFIG_IMPORT_BOOKINGS_TEXT, taxpool.get_script_dir().."import-jtl.tsv", "\t", 1, 0)

if not has_fieldnames then
taxpool.print_log("Die Datei muss Feldnamen enthalten")
return
end

if not res then 
-- in filename wird im fehlerfall eine fehlerausgabe gespeichert
taxpool.print_log(filename)
return 
end

local file, file_error = io.open(filename, "r")
if not file then
taxpool.message_box("Die Datei\n'"..filename.."'\nkonnte nicht geöffnet werden.\n"..file_error, taxpool.DLG_OK|taxpool.DLG_INFO)
return
end

-- zaehler f.d. importierten zeilen
local counter=0
local fields={}

taxpool.set_progress(2, "Daten werden importiert...")

for line in file:lines() do

	if not is_utf8 then
	line=taxpool.to_utf8(line) 
	end
	--taxpool.print_log(line)
	
	if counter==0 then --Feldtitel, Feldindices ermitteln
		local t=taxpool.tokenize(line, delim)
		for k, v in pairs(t) do 
			if str.length(v)>0 then
				fields[v]=k
			end
		end
	else --Felddaten
		local t=taxpool.tokenize(line, delim)
		
		local ErstellDatumRechnung=t[fields["Erstelldatum Rechnung"]]
		local ZahlungsDatum=t[fields["Zahlungsdatum"]]
		local Brutto=t[fields["Betrag Brutto (2 Nachkommastellen)"]]
		local Netto=t[fields["Betrag Netto (2 Nachkommastellen)"]]
		local USt=t[fields["Betrag USt. (2 Nachkommastellen)"]]
		local Debitor=t[fields["Debitorennummer"]]
		local Finanzkonto=t[fields["SKR03/04 Konto"]]
		local Erfolgskonto=t[fields["Steuerkonto"]]
		
		--taxpool.debug_print(str.arg("BEFORE: %1, %2\r\n", {{Finanzkonto}, {Erfolgskonto}}))
		
		local SteuerSchluessel=t[fields["Steuerschlüssel"]]
		local Zahlbetrag=t[fields["Zahlungsbetrag (2 Nachkommastellen)"]]
		local IstBezahlt=t[fields["Bezahlt"]]
		if IstBezahlt then
			if IstBezahlt=="y" or IstBezahlt=="Y" then
				IstBezahlt=true
			else
				IstBezahlt=false
			end
		end
		local RAFirma=t[fields["RA Firma"]]
		
		if ErstellDatumRechnung==nil or
   		   ZahlungsDatum==nil or
		   Brutto==nil or
		   Netto==nil or
		   USt==nil or
		   Debitor==nil or
   		   Erfolgskonto==nil or
		   Finanzkonto==nil or
		   SteuerSchluessel==nil or
		   Zahlbetrag==nil or
		   IstBezahlt==nil or
		   RAFirma==nil
		   then
		   taxpool.print_log("Es konnten nicht alle Datenfelder gefunden werden.")
		   break
		   end
		   
		if tonumber(SteuerSchluessel)==1 then
		SteuerSchluessel="0"
		end
		
		-- Neue Buchung erzeugen
		local buchung=taxpool.add_booking_entry()

		local Buchungstext=t[fields["Buchungstext"]]
		if Buchungstext then
			taxpool.set_booking_entry_field(buchung, taxpool.BEF_BUCHUNGSTEXT, Buchungstext)
			--taxpool.print_log("Buchungstext="..Buchungstext)
			taxpool.set_progress(5, "Buchungstext="..Buchungstext);
		end
				
		local Belegtext=t[fields["Belegtext"]]
		if Belegtext then
			taxpool.set_booking_entry_field(buchung, taxpool.BEF_BELEGNUMMERN_KREIS, Belegtext)
			taxpool.set_booking_entry_field(buchung, taxpool.BEF_BELEG, Belegtext)
		end
		
		local Belegnummer=t[fields["Belegnummer"]]
		if Belegnummer then
			taxpool.set_booking_entry_field(buchung, taxpool.BEF_BELEGNUMMERN_ZAEHLER, Belegnummer)
			if Belegtext==nil then
				Belegtext=""
			end
			if str.length(Belegtext)>0 then
				Belegtext=Belegtext.." "
			end
			Belegtext=Belegtext..Belegnummer
			taxpool.set_booking_entry_field(buchung, taxpool.BEF_BELEG, Belegtext)
		end
		
		-- evtl. Kunden neu anlegen
		if taxpool.is_debitor(tonumber(Debitor)) then
		local debID, err=taxpool.add_debitor_entry(tonumber(Debitor), RAFirma)
			if dbID<0 then
				taxpool.print_log(err)
			end
		end
		
		--kein erfolgskonto angegeben ?
		if tonumber(Erfolgskonto)<=0 then
			if str.length(SteuerSchluessel)>0 then
				local ErfolgskontoNeu=taxpool.get_std_account_no_by_taxinfo(taxpool.STEUERINFO_STEUERSCHLUESSEL, taxpool.EINNAHME, ErstellDatumRechnung, SteuerSchluessel)
				if ErfolgskontoNeu>0 then
					Erfolgskonto=ErfolgskontoNeu
				end
			else
				local dSteuerSatz=(tonumber(USt)*100.0)/tonumber(Netto)
				local ErfolgskontoNeu=taxpool.get_std_account_no_by_taxinfo(taxpool.STEUERINFO_STEUERSATZ, taxpool.EINNAHME, ErstellDatumRechnung, dSteuerSatz)
				if ErfolgskontoNeu>0 then
					Erfolgskonto=ErfolgskontoNeu
				end
			end
		end
		
		--taxpool.debug_print(str.arg("AFTER: %1, %2\r\n", {{Finanzkonto}, {Erfolgskonto}}))
				
		local tax_type=taxpool.get_company_taxation_type(taxpool.get_year(ErstellDatumRechnung))
			if tax_type<0 then
			taxpool.print_log("Keine Berechnung der Buchungsdaten möglich, da der Versteuerungstyp nicht ermittelt werden, kann.")
			break
		end
		
		if tax_type==taxpool.SOLL_VERSTEUERUNG and tonumber(Debitor)>0 then
			taxpool.set_booking_entry_field(buchung, 
						taxpool.BEF_BELEGDATUM, ErstellDatumRechnung,
						taxpool.BEF_BRUTTO, Brutto,
						taxpool.BEF_NETTO, Netto,
						--taxpool.BEF_STEUER_BETRAG, USt,
						taxpool.BEF_SOLLKONTO, Debitor,
						taxpool.BEF_HABENKONTO, Erfolgskonto)
			
			if IstBezahlt and taxpool.get_date(ZahlungsDatum)>0 and taxpool.is_equal(tonumber(Brutto), tonumber(Zahlbetrag), 2) then
				local buchung2=taxpool.add_booking_entry()
				taxpool.set_booking_entry_field(buchung2, 
						taxpool.BEF_BELEGDATUM, ZahlungsDatum,
						taxpool.BEF_BRUTTO, Zahlbetrag,
						taxpool.BEF_NETTO, Zahlbetrag,
						--taxpool.BEF_STEUER_BETRAG, 0,
						taxpool.BEF_SOLLKONTO, Finanzkonto,
						taxpool.BEF_HABENKONTO, Debitor)
			end
		else --taxpool.IST_VERSTEUERUNG
			taxpool.set_booking_entry_field(buchung, 
						taxpool.BEF_BELEGDATUM, ZahlungsDatum,
						taxpool.BEF_BRUTTO, Brutto,
						taxpool.BEF_SOLLKONTO, Finanzkonto,
						taxpool.BEF_HABENKONTO, Erfolgskonto)
		end
		
		--evtl. den Steuerschluessel beruecksichtigen:
		if tonumber(SteuerSchluessel)>0 then
				local taxid=taxpool.calc_tax_id("", Erfolgskonto, ErstellDatumRechnung, "", SteuerSchluessel)	
				if taxid>=0 then
					taxpool.set_booking_entry_field(buchung, taxpool.BEF_STEUERSATZ_ID, taxid)
				end
			end
	end --Ende Feldnamen verarbeiten
counter=counter+1
end -- Ende for-Schleife

taxpool.set_progress(3)
taxpool.print_log("Es wurden "..tostring(counter-1).." Datensätze importiert.")
taxpool.end_transaction(1,1)