--[[
Dies ist ein Beispielskript zum Bearbeiten von Buchungsdaten.
Bitte wenden Sie das Skript nicht auf eine bestehende Buchhaltung an, sondern legen Sie zum Testen der Funktionen eine separate Buchhaltungsdatei an. 
]]

if taxpool.message_box("Bei diesem Beispiel wird der Buchungstext bestehender Buchungen geändert.\nWollen Sie den Vorgang wirklich fortsetzen?", 
					   taxpool.DLG_YES|taxpool.DLG_NO|taxpool.DLG_QUESTION)==taxpool.DLG_NO then
return
end

-- Sicherungspunkt für Buchhaltungsdokument erstellen
taxpool.set_restore_mode(1)
taxpool.start_transaction(1)

--Alle Buchungen von 2014, ausgenommen ungueltige Buchungen 
local t=taxpool.get_bookings(0, "1.1.2014", "31.12.2014", -1, -1, taxpool.BES_UNGUELTIG, -1)
taxpool.print_log(#t.." Datensaetze")   

--Es wird in allen Buchungen nach dem Buchungstext 'alter_buchungs_text' gesucht und dieser in 'neuer_buchungs_text' geändert.
--Sofern Buchungen nicht geändert werden können und ein Storno und ein Duplikat möglich sind, wird die Buchung dupliziert, das Duplikat geändert und die alte Buchung storniert.
for i=1,#t do
local res, buchungstext=taxpool.get_booking_entry_field(t[i], taxpool.BEF_BUCHUNGSTEXT, taxpool.AS_STRING)
	if res then
		local neuer_text = string.gsub(buchungstext, "alter_buchungs_text", "neuer_buchungs_text")
		if neuer_text~=buchungstext then
			local success=false
			--Testen, ob die Buchung bearbeitet werden kann:
			local res, info=taxpool.get_booking_entry_edit_status(t[i], MODUS_BEARBEITEN)
				if res then --Ersetzen:
					local res, info=taxpool.set_booking_entry_field(t[i], taxpool.BEF_BUCHUNGSTEXT, neuer_text)
						if not res then 
							taxpool.print_log("Die Buchung Nr: "..tostring(i).."' konnte nicht geändert werden. Fehler: "..info)   
						else
							success=true
						end
				else
				--Testen, ob die Buchung dupliziert und storniert werden kann:
				local res, info=taxpool.get_booking_entry_edit_status(t[i], taxpool.MODUS_DUPLIKAT|taxpool.MODUS_STORNO, taxpool.DATUM_BELEGDATUM)
					if res then --Buchung duplizieren:
					local res, dupID=taxpool.booking_entry_edit_action(t[i], taxpool.MODUS_DUPLIKAT, taxpool.DATUM_BELEGDATUM)
						if res then --neuen Buchungstext setzen
							taxpool.set_booking_entry_field(dupID, taxpool.BEF_BUCHUNGSTEXT, neuer_text)
						--Alte Buchung stornieren:
						local res, stornoID=taxpool.booking_entry_edit_action(t[i], taxpool.MODUS_STORNO, DATUM_BELEGDATUM)
							if not res then --bei fehler, duplicat löschen
								taxpool.booking_entry_edit_action(dupID, taxpool.MODUS_LOESCHEN)
							else
								success=true
							end
						end
					else
						taxpool.print_log("Die Buchung Nr: "..tostring(i).."' konnte nicht geändert werden. Fehler: "..info)  
					end
				end
				
			if success then
				taxpool.print_log("Der Buchungstext '"..buchungstext.."' wurde zu '"..neuer_text.."' geändert")   
			end
		end
	end
end

taxpool.end_transaction(1,0)
