/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pdfbox.examples.signature;

import java.io.Closeable;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.RandomAccessFile;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import java.security.UnrecoverableKeyException;
import java.security.cert.CertificateException;
import java.util.Calendar;
import org.apache.pdfbox.Loader;
import org.apache.pdfbox.cos.COSName;
import org.apache.pdfbox.examples.signature.CreateSignatureBase;
import org.apache.pdfbox.examples.signature.SigUtils;
import org.apache.pdfbox.io.IOUtils;
import org.apache.pdfbox.io.MemoryUsageSetting;
import org.apache.pdfbox.pdmodel.PDDocument;
import org.apache.pdfbox.pdmodel.common.COSObjectable;
import org.apache.pdfbox.pdmodel.interactive.digitalsignature.ExternalSigningSupport;
import org.apache.pdfbox.pdmodel.interactive.digitalsignature.PDSignature;
import org.apache.pdfbox.pdmodel.interactive.digitalsignature.SignatureInterface;
import org.apache.pdfbox.pdmodel.interactive.digitalsignature.SignatureOptions;
import org.apache.pdfbox.pdmodel.interactive.digitalsignature.visible.PDVisibleSigProperties;
import org.apache.pdfbox.pdmodel.interactive.digitalsignature.visible.PDVisibleSignDesigner;
import org.apache.pdfbox.pdmodel.interactive.form.PDAcroForm;
import org.apache.pdfbox.pdmodel.interactive.form.PDSignatureField;
import org.apache.pdfbox.util.Hex;

public class CreateVisibleSignature
extends CreateSignatureBase {
    private SignatureOptions signatureOptions;
    private PDVisibleSignDesigner visibleSignDesigner;
    private final PDVisibleSigProperties visibleSignatureProperties = new PDVisibleSigProperties();
    private boolean lateExternalSigning = false;
    private MemoryUsageSetting memoryUsageSetting = MemoryUsageSetting.setupMainMemoryOnly();
    private PDDocument doc = null;

    public boolean isLateExternalSigning() {
        return this.lateExternalSigning;
    }

    public void setLateExternalSigning(boolean lateExternalSigning) {
        this.lateExternalSigning = lateExternalSigning;
    }

    public MemoryUsageSetting getMemoryUsageSetting() {
        return this.memoryUsageSetting;
    }

    public void setMemoryUsageSetting(MemoryUsageSetting memoryUsageSetting) {
        this.memoryUsageSetting = memoryUsageSetting;
    }

    public void setVisibleSignDesigner(String filename, int x, int y, int zoomPercent, InputStream imageStream, int page) throws IOException {
        this.doc = Loader.loadPDF((File)new File(filename), (MemoryUsageSetting)this.memoryUsageSetting);
        this.visibleSignDesigner = new PDVisibleSignDesigner(this.doc, imageStream, page);
        this.visibleSignDesigner.xAxis((float)x).yAxis((float)y).zoom((float)zoomPercent).adjustForRotation();
    }

    public void setVisibleSignDesigner(int zoomPercent, InputStream imageStream) throws IOException {
        this.visibleSignDesigner = new PDVisibleSignDesigner(imageStream);
        this.visibleSignDesigner.zoom((float)zoomPercent);
    }

    public void setVisibleSignatureProperties(String name, String location, String reason, int preferredSize, int page, boolean visualSignEnabled) {
        this.visibleSignatureProperties.signerName(name).signerLocation(location).signatureReason(reason).preferredSize(preferredSize).page(page).visualSignEnabled(visualSignEnabled).setPdVisibleSignature(this.visibleSignDesigner);
    }

    public void setVisibleSignatureProperties(String name, String location, String reason, boolean visualSignEnabled) {
        this.visibleSignatureProperties.signerName(name).signerLocation(location).signatureReason(reason).visualSignEnabled(visualSignEnabled).setPdVisibleSignature(this.visibleSignDesigner);
    }

    public CreateVisibleSignature(KeyStore keystore, char[] pin) throws KeyStoreException, UnrecoverableKeyException, NoSuchAlgorithmException, IOException, CertificateException {
        super(keystore, pin);
    }

    public void signPDF(File inputFile, File signedFile, String tsaUrl) throws IOException {
        this.signPDF(inputFile, signedFile, tsaUrl, null);
    }

    public void signPDF(File inputFile, File signedFile, String tsaUrl, String signatureFieldName) throws IOException {
        block37: {
            if (inputFile == null || !inputFile.exists()) {
                throw new IOException("Document for signing does not exist");
            }
            this.setTsaUrl(tsaUrl);
            if (this.doc == null) {
                this.doc = Loader.loadPDF((File)inputFile, (MemoryUsageSetting)this.memoryUsageSetting);
            }
            try (FileOutputStream fos = new FileOutputStream(signedFile);){
                CreateVisibleSignature signatureInterface;
                PDAcroForm acroForm;
                int accessPermissions = SigUtils.getMDPPermission(this.doc);
                if (accessPermissions == 1) {
                    throw new IllegalStateException("No changes to the document are permitted due to DocMDP transform parameters dictionary");
                }
                PDSignature signature = this.findExistingSignature(this.doc, signatureFieldName);
                if (signature == null) {
                    signature = new PDSignature();
                }
                if (this.doc.getVersion() >= 1.5f && accessPermissions == 0) {
                    SigUtils.setMDPPermission(this.doc, signature, 2);
                }
                if ((acroForm = this.doc.getDocumentCatalog().getAcroForm(null)) != null && acroForm.getNeedAppearances()) {
                    if (acroForm.getFields().isEmpty()) {
                        acroForm.getCOSObject().removeItem(COSName.NEED_APPEARANCES);
                    } else {
                        System.out.println("/NeedAppearances is set, signature may be ignored by Adobe Reader");
                    }
                }
                signature.setFilter(PDSignature.FILTER_ADOBE_PPKLITE);
                signature.setSubFilter(PDSignature.SUBFILTER_ADBE_PKCS7_DETACHED);
                if (this.visibleSignatureProperties != null) {
                    this.visibleSignatureProperties.buildSignature();
                    signature.setName(this.visibleSignatureProperties.getSignerName());
                    signature.setLocation(this.visibleSignatureProperties.getSignerLocation());
                    signature.setReason(this.visibleSignatureProperties.getSignatureReason());
                }
                signature.setSignDate(Calendar.getInstance());
                CreateVisibleSignature createVisibleSignature = signatureInterface = this.isExternalSigning() ? null : this;
                if (this.visibleSignatureProperties != null && this.visibleSignatureProperties.isVisualSignEnabled()) {
                    this.signatureOptions = new SignatureOptions();
                    this.signatureOptions.setVisualSignature(this.visibleSignatureProperties.getVisibleSignature());
                    this.signatureOptions.setPage(this.visibleSignatureProperties.getPage() - 1);
                    this.doc.addSignature(signature, (SignatureInterface)signatureInterface, this.signatureOptions);
                } else {
                    this.doc.addSignature(signature, (SignatureInterface)signatureInterface);
                }
                if (this.isExternalSigning()) {
                    ExternalSigningSupport externalSigning = this.doc.saveIncrementalForExternalSigning((OutputStream)fos);
                    byte[] cmsSignature = this.sign(externalSigning.getContent());
                    if (this.isLateExternalSigning()) {
                        externalSigning.setSignature(new byte[0]);
                        int offset = signature.getByteRange()[1] + 1;
                        try (RandomAccessFile raf = new RandomAccessFile(signedFile, "rw");){
                            raf.seek(offset);
                            raf.write(Hex.getBytes((byte[])cmsSignature));
                            break block37;
                        }
                    }
                    externalSigning.setSignature(cmsSignature);
                    break block37;
                }
                this.doc.saveIncremental((OutputStream)fos);
            }
        }
        IOUtils.closeQuietly((Closeable)this.signatureOptions);
        IOUtils.closeQuietly((Closeable)this.doc);
    }

    private PDSignature findExistingSignature(PDDocument doc, String sigFieldName) {
        PDSignatureField signatureField;
        PDSignature signature = null;
        PDAcroForm acroForm = doc.getDocumentCatalog().getAcroForm(null);
        if (acroForm != null && (signatureField = (PDSignatureField)acroForm.getField(sigFieldName)) != null) {
            signature = signatureField.getSignature();
            if (signature == null) {
                signature = new PDSignature();
                signatureField.getCOSObject().setItem(COSName.V, (COSObjectable)signature);
            } else {
                throw new IllegalStateException("The signature field " + sigFieldName + " is already signed.");
            }
        }
        return signature;
    }

    public static void main(String[] args) throws KeyStoreException, CertificateException, IOException, NoSuchAlgorithmException, UnrecoverableKeyException {
        int page;
        File signedDocumentFile;
        if (args.length < 4) {
            CreateVisibleSignature.usage();
            System.exit(1);
        }
        String tsaUrl = null;
        boolean externalSig = false;
        for (int i = 0; i < args.length; ++i) {
            if ("-tsa".equals(args[i])) {
                if (++i >= args.length) {
                    CreateVisibleSignature.usage();
                    System.exit(1);
                }
                tsaUrl = args[i];
            }
            if (!"-e".equals(args[i])) continue;
            externalSig = true;
        }
        File ksFile = new File(args[0]);
        KeyStore keystore = KeyStore.getInstance("PKCS12");
        char[] pin = args[1].toCharArray();
        keystore.load(new FileInputStream(ksFile), pin);
        File documentFile = new File(args[2]);
        CreateVisibleSignature signing = new CreateVisibleSignature(keystore, (char[])pin.clone());
        try (FileInputStream imageStream = new FileInputStream(args[3]);){
            String name = documentFile.getName();
            String substring = name.substring(0, name.lastIndexOf(46));
            signedDocumentFile = new File(documentFile.getParent(), substring + "_signed.pdf");
            page = 1;
            signing.setVisibleSignDesigner(args[2], 0, 0, -50, imageStream, page);
        }
        signing.setVisibleSignatureProperties("name", "location", "Security", 0, page, true);
        signing.setExternalSigning(externalSig);
        signing.signPDF(documentFile, signedDocumentFile, tsaUrl);
    }

    private static void usage() {
        System.err.println("Usage: java " + CreateVisibleSignature.class.getName() + " <pkcs12-keystore-file> <pin> <input-pdf> <sign-image>\noptions:\n  -tsa <url>    sign timestamp using the given TSA server\n  -e            sign using external signature creation scenario");
    }
}

