/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pdfbox.examples.pdmodel;

import java.io.File;
import java.io.IOException;
import org.apache.fontbox.ttf.TTFParser;
import org.apache.fontbox.ttf.TrueTypeFont;
import org.apache.pdfbox.pdmodel.PDDocument;
import org.apache.pdfbox.pdmodel.PDPage;
import org.apache.pdfbox.pdmodel.PDPageContentStream;
import org.apache.pdfbox.pdmodel.font.PDFont;
import org.apache.pdfbox.pdmodel.font.PDType0Font;

public class EmbeddedVerticalFonts {
    private EmbeddedVerticalFonts() {
    }

    public static void main(String[] args) throws IOException {
        PDDocument document = new PDDocument();
        PDPage page = new PDPage();
        document.addPage(page);
        File ipafont = new File("ipag.ttf");
        PDType0Font hfont = PDType0Font.load((PDDocument)document, (File)ipafont);
        PDType0Font vfont = PDType0Font.loadVertical((PDDocument)document, (File)ipafont);
        TrueTypeFont ttf = new TTFParser().parse(ipafont);
        PDType0Font vfont2 = PDType0Font.loadVertical((PDDocument)document, (TrueTypeFont)ttf, (boolean)true);
        ttf.disableGsubFeature("vrt2");
        ttf.disableGsubFeature("vert");
        try (PDPageContentStream contentStream = new PDPageContentStream(document, page);){
            contentStream.beginText();
            contentStream.setFont((PDFont)hfont, 20.0f);
            contentStream.setLeading(25.0f);
            contentStream.newLineAtOffset(20.0f, 300.0f);
            contentStream.showText("Key:");
            contentStream.newLine();
            contentStream.showText("\u2460 Horizontal");
            contentStream.newLine();
            contentStream.showText("\u2461 Vertical with substitution");
            contentStream.newLine();
            contentStream.showText("\u2462 Vertical without substitution");
            contentStream.endText();
            contentStream.beginText();
            contentStream.setFont((PDFont)hfont, 20.0f);
            contentStream.newLineAtOffset(20.0f, 650.0f);
            contentStream.showText("\u2460\u300c\u3042\u30fc\u3060\u3053\u30fc\u3060\u300d");
            contentStream.endText();
            contentStream.beginText();
            contentStream.setFont((PDFont)vfont, 20.0f);
            contentStream.newLineAtOffset(50.0f, 600.0f);
            contentStream.showText("\u2461\u300c\u3042\u30fc\u3060\u3053\u30fc\u3060\u300d");
            contentStream.endText();
            contentStream.beginText();
            contentStream.setFont((PDFont)vfont2, 20.0f);
            contentStream.newLineAtOffset(100.0f, 600.0f);
            contentStream.showText("\u2462\u300c\u3042\u30fc\u3060\u3053\u30fc\u3060\u300d");
            contentStream.endText();
        }
        document.save("vertical.pdf");
    }
}

