/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pdfbox.examples.pdmodel;

import java.awt.Color;
import java.io.File;
import java.io.IOException;
import org.apache.pdfbox.Loader;
import org.apache.pdfbox.pdmodel.PDDocument;
import org.apache.pdfbox.pdmodel.PDPage;
import org.apache.pdfbox.pdmodel.PDPageContentStream;
import org.apache.pdfbox.pdmodel.common.PDRectangle;
import org.apache.pdfbox.pdmodel.font.PDFont;
import org.apache.pdfbox.pdmodel.font.PDType1Font;
import org.apache.pdfbox.util.Matrix;

public class AddMessageToEachPage {
    public void doIt(String file, String message, String outfile) throws IOException {
        try (PDDocument doc = Loader.loadPDF((File)new File(file));){
            PDType1Font font = PDType1Font.HELVETICA_BOLD;
            float fontSize = 36.0f;
            for (PDPage page : doc.getPages()) {
                PDRectangle pageSize = page.getMediaBox();
                float stringWidth = font.getStringWidth(message) * fontSize / 1000.0f;
                int rotation = page.getRotation();
                boolean rotate = rotation == 90 || rotation == 270;
                float pageWidth = rotate ? pageSize.getHeight() : pageSize.getWidth();
                float pageHeight = rotate ? pageSize.getWidth() : pageSize.getHeight();
                float centerX = rotate ? pageHeight / 2.0f : (pageWidth - stringWidth) / 2.0f;
                float centerY = rotate ? (pageWidth - stringWidth) / 2.0f : pageHeight / 2.0f;
                PDPageContentStream contentStream = new PDPageContentStream(doc, page, PDPageContentStream.AppendMode.APPEND, true, true);
                Throwable throwable = null;
                try {
                    contentStream.beginText();
                    contentStream.setFont((PDFont)font, fontSize);
                    contentStream.setNonStrokingColor(Color.red);
                    if (rotate) {
                        contentStream.setTextMatrix(Matrix.getRotateInstance((double)1.5707963267948966, (float)centerX, (float)centerY));
                    } else {
                        contentStream.setTextMatrix(Matrix.getTranslateInstance((float)centerX, (float)centerY));
                    }
                    contentStream.showText(message);
                    contentStream.endText();
                }
                catch (Throwable throwable2) {
                    throwable = throwable2;
                    throw throwable2;
                }
                finally {
                    if (contentStream == null) continue;
                    if (throwable != null) {
                        try {
                            contentStream.close();
                        }
                        catch (Throwable throwable3) {
                            throwable.addSuppressed(throwable3);
                        }
                        continue;
                    }
                    contentStream.close();
                }
            }
            doc.save(outfile);
        }
    }

    public static void main(String[] args) throws IOException {
        AddMessageToEachPage app = new AddMessageToEachPage();
        if (args.length != 3) {
            app.usage();
        } else {
            app.doIt(args[0], args[1], args[2]);
        }
    }

    private void usage() {
        System.err.println("usage: " + this.getClass().getName() + " <input-file> <Message> <output-file>");
    }
}

