/*
 * Decompiled with CFR 0.152.
 */
package pdftsastamp;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.ArrayList;
import org.bouncycastle.asn1.ASN1EncodableVector;
import org.bouncycastle.asn1.ASN1ObjectIdentifier;
import org.bouncycastle.asn1.ASN1Primitive;
import org.bouncycastle.asn1.DERSet;
import org.bouncycastle.asn1.cms.Attribute;
import org.bouncycastle.asn1.cms.AttributeTable;
import org.bouncycastle.asn1.cms.Attributes;
import org.bouncycastle.asn1.pkcs.PKCSObjectIdentifiers;
import org.bouncycastle.cms.CMSSignedData;
import org.bouncycastle.cms.SignerInformation;
import org.bouncycastle.cms.SignerInformationStore;
import org.bouncycastle.tsp.TimeStampToken;
import pdftsastamp.TSAClient;

public class ValidationTimeStamp {
    private TSAClient tsaClient;

    public ValidationTimeStamp(String tsaUrl, String tsaUsername, String tsaPassword, MessageDigest tsaDigest, boolean bTrustAll) throws NoSuchAlgorithmException, MalformedURLException {
        if (tsaUrl != null) {
            MessageDigest digest = tsaDigest == null ? MessageDigest.getInstance("SHA-256") : tsaDigest;
            this.tsaClient = new TSAClient(new URL(tsaUrl), tsaUsername, tsaPassword, digest, bTrustAll);
        }
    }

    public byte[] getTimeStampToken(InputStream content) throws IOException {
        TimeStampToken timeStampToken = this.tsaClient.getTimeStampToken(content);
        return timeStampToken.getEncoded();
    }

    public CMSSignedData addSignedTimeStamp(CMSSignedData signedData) throws IOException {
        SignerInformationStore signerStore = signedData.getSignerInfos();
        ArrayList<SignerInformation> newSigners = new ArrayList<SignerInformation>();
        for (SignerInformation signer : signerStore.getSigners()) {
            newSigners.add(this.signTimeStamp(signer));
        }
        return CMSSignedData.replaceSigners(signedData, new SignerInformationStore(newSigners));
    }

    private SignerInformation signTimeStamp(SignerInformation signer) throws IOException {
        AttributeTable unsignedAttributes = signer.getUnsignedAttributes();
        ASN1EncodableVector vector = new ASN1EncodableVector();
        if (unsignedAttributes != null) {
            vector = unsignedAttributes.toASN1EncodableVector();
        }
        TimeStampToken timeStampToken = this.tsaClient.getTimeStampToken(new ByteArrayInputStream(signer.getSignature()));
        byte[] token = timeStampToken.getEncoded();
        ASN1ObjectIdentifier oid = PKCSObjectIdentifiers.id_aa_signatureTimeStampToken;
        Attribute signatureTimeStamp = new Attribute(oid, new DERSet(ASN1Primitive.fromByteArray(token)));
        vector.add(signatureTimeStamp);
        Attributes signedAttributes = new Attributes(vector);
        return SignerInformation.replaceUnsignedAttributes(signer, new AttributeTable(signedAttributes));
    }

    public byte[] getTSAResponse() {
        return this.tsaClient.tsaResponse;
    }
}

