/*
 * Decompiled with CFR 0.152.
 */
package pdftsastamp;

import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.PrintWriter;
import java.lang.management.ManagementFactory;
import java.net.URL;
import java.net.URLConnection;
import java.nio.file.Files;
import java.nio.file.Paths;
import java.security.DigestInputStream;
import java.security.MessageDigest;
import java.security.Security;
import java.security.cert.Certificate;
import java.security.cert.CertificateFactory;
import java.security.cert.X509Certificate;
import java.text.SimpleDateFormat;
import java.util.Arrays;
import java.util.Calendar;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.TimeZone;
import java.util.UUID;
import org.apache.commons.cli.CommandLine;
import org.apache.commons.cli.DefaultParser;
import org.apache.commons.cli.HelpFormatter;
import org.apache.commons.cli.Option;
import org.apache.commons.cli.Options;
import org.apache.commons.cli.ParseException;
import org.apache.pdfbox.Loader;
import org.apache.pdfbox.cos.COSDictionary;
import org.apache.pdfbox.examples.signature.SigUtils;
import org.apache.pdfbox.examples.signature.cert.CertificateVerifier;
import org.apache.pdfbox.examples.signature.validation.AddValidationInformation;
import org.apache.pdfbox.io.RandomAccessReadBufferedFile;
import org.apache.pdfbox.pdfparser.PDFParser;
import org.apache.pdfbox.pdmodel.PDDocument;
import org.apache.pdfbox.pdmodel.PDDocumentCatalog;
import org.apache.pdfbox.pdmodel.PDDocumentNameDictionary;
import org.apache.pdfbox.pdmodel.PDEmbeddedFilesNameTreeNode;
import org.apache.pdfbox.pdmodel.common.filespecification.PDComplexFileSpecification;
import org.apache.pdfbox.pdmodel.common.filespecification.PDEmbeddedFile;
import org.apache.pdfbox.pdmodel.encryption.SecurityProvider;
import org.apache.pdfbox.pdmodel.font.PDType1Font;
import org.apache.pdfbox.pdmodel.interactive.digitalsignature.COSFilterInputStream;
import org.apache.pdfbox.pdmodel.interactive.digitalsignature.PDSignature;
import org.apache.pdfbox.tools.TextToPDF;
import org.bouncycastle.cert.X509CertificateHolder;
import org.bouncycastle.cms.CMSSignedData;
import org.bouncycastle.tsp.TSPException;
import org.bouncycastle.tsp.TimeStampResponse;
import org.bouncycastle.tsp.TimeStampToken;
import org.bouncycastle.tsp.TimeStampTokenInfo;
import org.bouncycastle.util.encoders.Hex;
import pdftsastamp.CreateSignedTimeStamp;

public class Pdftsastamp {
    private static PDEmbeddedFile getEmbeddedFile(PDComplexFileSpecification fileSpec) {
        PDEmbeddedFile embeddedFile = null;
        if (fileSpec != null) {
            embeddedFile = fileSpec.getEmbeddedFileUnicode();
            if (embeddedFile == null) {
                embeddedFile = fileSpec.getEmbeddedFileDos();
            }
            if (embeddedFile == null) {
                embeddedFile = fileSpec.getEmbeddedFileMac();
            }
            if (embeddedFile == null) {
                embeddedFile = fileSpec.getEmbeddedFileUnix();
            }
            if (embeddedFile == null) {
                embeddedFile = fileSpec.getEmbeddedFile();
            }
        }
        return embeddedFile;
    }

    public static void main(String[] args) {
        boolean isDebug = ManagementFactory.getRuntimeMXBean().getInputArguments().toString().indexOf("-agentlib:jdwp") > 0;
        String inname = "Y:/java/pdf-timestamp/pdftsastamp/test/test-input.txt";
        String outname = "Y:/java/pdf-timestamp/pdftsastamp/test/result.pdf";
        String logname = "Y:/java/pdf-timestamp/pdftsastamp/test/result.txt";
        String tsaUrl = "https://freetsa.org/tsr";
        tsaUrl = "https://104.244.77.137/tsr";
        String tsaUser = null;
        String tsaPWD = null;
        String tsaDigest = null;
        boolean bCreatePDF = false;
        boolean bCheckTSAResponse = false;
        boolean bTrustAll = false;
        String tsaResponse = "";
        if (!isDebug) {
            Options options = new Options();
            Option command = new Option("c", true, "command");
            command.setRequired(true);
            options.addOption(command);
            Option input = new Option("i", true, "input file");
            input.setRequired(true);
            options.addOption(input);
            Option output = new Option("o", true, "output file");
            output.setRequired(false);
            options.addOption(output);
            Option result = new Option("r", true, "result file");
            result.setRequired(false);
            options.addOption(result);
            Option _tsaUrl = new Option("tsaurl", true, "tsa url");
            _tsaUrl.setRequired(false);
            options.addOption(_tsaUrl);
            Option _tsaUser = new Option("tsauser", true, "tsa user");
            _tsaUser.setRequired(false);
            options.addOption(_tsaUser);
            Option _tsaPWD = new Option("tsapwd", true, "tsa pwd");
            _tsaPWD.setRequired(false);
            options.addOption(_tsaPWD);
            Option _tsaDigest = new Option("tsadigest", true, "tsa digest");
            _tsaDigest.setRequired(false);
            options.addOption(_tsaDigest);
            Option _trustAll = new Option("trustall", false, "trust all certificates");
            _trustAll.setRequired(false);
            options.addOption(_trustAll);
            DefaultParser parser = new DefaultParser();
            HelpFormatter formatter = new HelpFormatter();
            CommandLine cmd = null;
            try {
                cmd = parser.parse(options, args);
            }
            catch (ParseException e) {
                System.out.println(e.getMessage());
                formatter.printHelp("utility-name", options);
                System.exit(1);
            }
            String csCommand = cmd.getOptionValue("c");
            bCreatePDF = csCommand.equalsIgnoreCase("signpdf");
            if (!bCreatePDF) {
                bCheckTSAResponse = csCommand.equalsIgnoreCase("checktsaresponse");
            }
            inname = cmd.getOptionValue("i");
            logname = cmd.getOptionValue("r");
            if (cmd.hasOption("trustall")) {
                bTrustAll = true;
            }
            if (bCreatePDF) {
                outname = cmd.getOptionValue("o");
                tsaUrl = cmd.getOptionValue("tsaurl");
                tsaUser = cmd.getOptionValue("tsauser");
                tsaPWD = cmd.getOptionValue("tsapwd");
                tsaDigest = cmd.getOptionValue("tsadigest");
            }
        } else {
            bCreatePDF = true;
        }
        PrintWriter writer = null;
        File fileOut2 = null;
        try {
            SimpleDateFormat sdf;
            TimeZone tz;
            File testFile;
            Object ef;
            writer = new PrintWriter(logname, "UTF-8");
            if (bCreatePDF) {
                File fileCreate = File.createTempFile(UUID.randomUUID().toString(), ".pdf");
                fileCreate.deleteOnExit();
                TextToPDF textToPDF = new TextToPDF();
                textToPDF.setFont(PDType1Font.COURIER);
                textToPDF.setFontSize(6);
                textToPDF.setLandscape(true);
                PDDocument pdf = textToPDF.createPDFFromText(new InputStreamReader((InputStream)new FileInputStream(inname), "UTF8"));
                PDDocumentNameDictionary names = new PDDocumentNameDictionary(pdf.getDocumentCatalog());
                PDEmbeddedFilesNameTreeNode efTree = names.getEmbeddedFiles();
                if (Objects.isNull(efTree)) {
                    efTree = new PDEmbeddedFilesNameTreeNode();
                }
                HashMap<String, PDComplexFileSpecification> efMap = new HashMap<String, PDComplexFileSpecification>();
                long nFileSize = 0L;
                nFileSize = new File(inname).length();
                boolean bAddAttachment = true;
                if (bAddAttachment) {
                    PDComplexFileSpecification fs = new PDComplexFileSpecification();
                    String csName = new File(inname).getName();
                    fs.setFile(csName);
                    fs.setFileDescription("List of files.");
                    try (FileInputStream is = new FileInputStream(inname);){
                        ef = new PDEmbeddedFile(pdf, is);
                        ((PDEmbeddedFile)ef).setCreationDate(Calendar.getInstance());
                        ((PDEmbeddedFile)ef).setSize((int)nFileSize);
                        fs.setEmbeddedFile((PDEmbeddedFile)ef);
                        efMap.put(csName, fs);
                    }
                    efTree.setNames(efMap);
                    names.setEmbeddedFiles(efTree);
                    pdf.getDocumentCatalog().setNames(names);
                }
                try {
                    fileCreate.delete();
                }
                catch (Exception fs) {
                    // empty catch block
                }
                pdf.save(fileCreate);
                File fileTemp = File.createTempFile("pdfbox-", ".pdf");
                fileTemp.deleteOnExit();
                fileOut2 = new File(outname);
                if (fileOut2.exists()) {
                    fileOut2.delete();
                }
                CreateSignedTimeStamp signing = new CreateSignedTimeStamp(tsaUrl, tsaUser, tsaPWD, tsaDigest == null ? null : MessageDigest.getInstance(tsaDigest), bTrustAll);
                signing.signDetached(fileCreate, fileTemp);
                if (signing.tsaResponse != null) {
                    tsaResponse = Hex.toHexString(signing.tsaResponse);
                }
                Security.addProvider(SecurityProvider.getProvider());
                AddValidationInformation addOcspInformation = new AddValidationInformation();
                addOcspInformation.validateSignature(fileTemp, fileOut2);
            }
            String csModTime = "";
            String csStampTime = "";
            String csDigest = "";
            String csAttachments = "";
            String csTSAName = "";
            boolean bSignatureOK = false;
            File file = testFile = bCreatePDF ? fileOut2 : new File(inname);
            if (!bCheckTSAResponse) {
                tz = TimeZone.getTimeZone("UTC");
                sdf = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss:SSS");
                sdf.setTimeZone(tz);
                RandomAccessReadBufferedFile raFile = new RandomAccessReadBufferedFile(testFile);
                PDFParser parser = new PDFParser(raFile, null);
                try (PDDocument document = parser.parse(false);){
                    ef = document.getSignatureDictionaries().iterator();
                    while (ef.hasNext()) {
                        PDSignature sig = (PDSignature)ef.next();
                        COSDictionary sigDict = sig.getCOSObject();
                        byte[] contents = sig.getContents();
                        try (FileInputStream fis = new FileInputStream(testFile);
                             COSFilterInputStream signedContentAsStream = new COSFilterInputStream(fis, sig.getByteRange());){
                            String subFilter;
                            System.out.println("Signature found");
                            if (sig.getName() != null) {
                                System.out.println("Name:     " + sig.getName());
                            }
                            if (sig.getSignDate() != null) {
                                csModTime = sdf.format(sig.getSignDate().getTime());
                                System.out.println("Modified: " + csModTime);
                            }
                            if ((subFilter = sig.getSubFilter()) == null || !subFilter.equalsIgnoreCase("ETSI.RFC3161")) continue;
                            TimeStampToken timeStampToken = new TimeStampToken(new CMSSignedData(contents));
                            TimeStampTokenInfo timeStampInfo = timeStampToken.getTimeStampInfo();
                            csStampTime = sdf.format(timeStampInfo.getGenTime());
                            System.out.println("Time stamp gen time: " + csStampTime);
                            if (timeStampInfo.getTsa() != null) {
                                System.out.println("Time stamp tsa name: " + timeStampInfo.getTsa().getName());
                                csTSAName = timeStampInfo.getTsa().getName().toString();
                            }
                            byte[] digest = timeStampInfo.getMessageImprintDigest();
                            csDigest = Hex.toHexString(digest);
                            String hashAlgorithm = timeStampInfo.getMessageImprintAlgOID().getId();
                            MessageDigest md = MessageDigest.getInstance(hashAlgorithm);
                            try (DigestInputStream dis = new DigestInputStream(signedContentAsStream, md);){
                                while (dis.read() != -1) {
                                }
                            }
                            if (Arrays.equals(md.digest(), timeStampInfo.getMessageImprintDigest())) {
                                System.out.println("ETSI.RFC3161 timestamp signature verified");
                                bSignatureOK = true;
                            } else {
                                System.err.println("ETSI.RFC3161 timestamp signature verification failed");
                            }
                            if (bCreatePDF) continue;
                            CertificateFactory factory = CertificateFactory.getInstance("X.509");
                            ByteArrayInputStream certStream = new ByteArrayInputStream(contents);
                            Collection<? extends Certificate> certs = factory.generateCertificates(certStream);
                            System.out.println("certs=" + certs);
                            X509Certificate certFromTimeStamp = (X509Certificate)certs.iterator().next();
                            int n = certFromTimeStamp.getSignature().length;
                            SigUtils.checkTimeStampCertificateUsage((X509Certificate)certFromTimeStamp);
                            SigUtils.validateTimestampToken((TimeStampToken)timeStampToken);
                            boolean bl = CertificateVerifier.isSelfSigned((X509Certificate)certFromTimeStamp);
                        }
                    }
                }
            }
            if (!bCreatePDF && !bCheckTSAResponse) {
                try (PDDocument pd = Loader.loadPDF(testFile);){
                    Map embeddedFileNames;
                    PDDocumentCatalog catalog = pd.getDocumentCatalog();
                    PDDocumentNameDictionary names = catalog.getNames();
                    PDEmbeddedFilesNameTreeNode embeddedFiles = names.getEmbeddedFiles();
                    if (embeddedFiles != null && (ef = (embeddedFileNames = embeddedFiles.getNames()).entrySet().iterator()).hasNext()) {
                        Map.Entry entry = ef.next();
                        System.out.println("Found embedded File: " + entry.getKey() + ":");
                        PDComplexFileSpecification fileSpec = (PDComplexFileSpecification)entry.getValue();
                        PDEmbeddedFile embeddedFile = Pdftsastamp.getEmbeddedFile(fileSpec);
                        csAttachments = Hex.toHexString(embeddedFile.toByteArray());
                    }
                }
            }
            if (bCheckTSAResponse) {
                TimeStampResponse response;
                tz = TimeZone.getTimeZone("UTC");
                sdf = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss:SSS");
                sdf.setTimeZone(tz);
                byte[] b = Files.readAllBytes(Paths.get(inname, new String[0]));
                try {
                    response = new TimeStampResponse(b);
                }
                catch (TSPException e) {
                    throw new IOException(e);
                }
                TimeStampToken timeStampToken = response.getTimeStampToken();
                if (timeStampToken == null) {
                    throw new IOException("Response from  does not have a time stamp token, status: " + response.getStatus() + " (" + response.getStatusString() + ")");
                }
                TimeStampTokenInfo timeStampInfo = timeStampToken.getTimeStampInfo();
                csStampTime = sdf.format(timeStampInfo.getGenTime());
                System.out.println("Time stamp gen time: " + csStampTime);
                if (timeStampInfo.getTsa() != null) {
                    System.out.println("Time stamp tsa name: " + timeStampInfo.getTsa().getName());
                    csTSAName = timeStampInfo.getTsa().getName().toString();
                }
                byte[] digest = timeStampInfo.getMessageImprintDigest();
                csDigest = Hex.toHexString(digest);
                Collection<X509CertificateHolder> tstMatches = timeStampToken.getCertificates().getMatches(timeStampToken.getSID());
                X509CertificateHolder certificateHolder = tstMatches.iterator().next();
                CertificateFactory certFactory = CertificateFactory.getInstance("X.509");
                ByteArrayInputStream in = new ByteArrayInputStream(certificateHolder.getEncoded());
                X509Certificate cert = (X509Certificate)certFactory.generateCertificate(in);
                SigUtils.checkTimeStampCertificateUsage((X509Certificate)cert);
                SigUtils.validateTimestampToken((TimeStampToken)timeStampToken);
                boolean bSelf = CertificateVerifier.isSelfSigned((X509Certificate)cert);
                if (bSelf) {
                    System.out.println("Self signed");
                }
            }
            writer.println("VER=1");
            writer.println("RESULT=1");
            writer.println(csModTime);
            writer.println(csStampTime);
            writer.println(csDigest);
            writer.println(tsaResponse);
            writer.println(csAttachments);
            writer.println(bSignatureOK ? "1" : "0");
            writer.println(csTSAName);
            writer.println("ENDRESULT");
            writer.close();
        }
        catch (Exception e) {
            if (writer != null) {
                writer.println("VER=1");
                writer.println("RESULT=0");
                e.printStackTrace(writer);
                writer.println("ENDRESULT");
                writer.close();
            }
            e.printStackTrace();
        }
    }

    static boolean CheckInternetConnection() {
        try {
            URL u = new URL("https://www.google.com");
            URLConnection conn = u.openConnection();
            conn.connect();
            System.out.println("Internet connection established");
            return true;
        }
        catch (Exception e) {
            System.out.println("No Internet Connection available, please connect with internet");
            return false;
        }
    }
}

