/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pdfbox.cos;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.FilterInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import org.apache.pdfbox.cos.COSDictionary;
import org.apache.pdfbox.filter.DecodeOptions;
import org.apache.pdfbox.filter.DecodeResult;
import org.apache.pdfbox.filter.Filter;

public final class COSInputStream
extends FilterInputStream {
    private final List<DecodeResult> decodeResults;

    static COSInputStream create(List<Filter> filters, COSDictionary parameters, InputStream in) throws IOException {
        return COSInputStream.create(filters, parameters, in, DecodeOptions.DEFAULT);
    }

    static COSInputStream create(List<Filter> filters, COSDictionary parameters, InputStream in, DecodeOptions options) throws IOException {
        ArrayList<DecodeResult> results = new ArrayList<DecodeResult>();
        InputStream input = in;
        if (!filters.isEmpty()) {
            HashSet<Filter> filterSet = new HashSet<Filter>(filters);
            if (filterSet.size() != filters.size()) {
                throw new IOException("Duplicate");
            }
            ByteArrayOutputStream output = new ByteArrayOutputStream();
            for (int i = 0; i < filters.size(); ++i) {
                output.reset();
                results.add(filters.get(i).decode(input, output, parameters, i, options));
                input = new ByteArrayInputStream(output.toByteArray());
            }
        }
        return new COSInputStream(input, results);
    }

    private COSInputStream(InputStream input, List<DecodeResult> decodeResults) {
        super(input);
        this.decodeResults = decodeResults;
    }

    public DecodeResult getDecodeResult() {
        if (this.decodeResults.isEmpty()) {
            return DecodeResult.DEFAULT;
        }
        return this.decodeResults.get(this.decodeResults.size() - 1);
    }
}

