--[[
Dies ist ein Beispielskript zum Importieren von Buchungsdaten aus einer Textdatei, die u.A. auch Splitt-Buchungen enthält (z.B. die beiliegende Datei 'beispiel_daten1.csv').
Bitte importieren Sie die Beispiel-Daten nicht in eine bestehende Buchhaltung, sondern legen Sie zum Testen der Funktionen eine separate Buchhaltungsdatei an. 
]]

if taxpool.message_box("Bei diesem Beispiel werden Daten aus einer Textdatei importiert.\nDas Beispiel sollte nur mit einer Testbuchhaltung ausgeführt werden\nWollen Sie den Vorgang wirklich fortsetzen?", 
					   taxpool.DLG_YES|taxpool.DLG_NO|taxpool.DLG_QUESTION)==taxpool.DLG_NO then
return
end

-- Sicherungspunkt für Buchhaltungsdokument erstellen
-- taxpool.set_restore_mode(1)

taxpool.start_transaction(1)

--Einstellungsdialog oeffnen
local res, filename, delim, has_fieldnames, is_utf8=taxpool.get_options(taxpool.CONFIG_IMPORT_BOOKINGS_TEXT, taxpool.get_script_dir().."beispiel_daten1.csv", ";", 1, 1)

if not res then 
-- in filename wird im fehlerfall eine fehlerausgabe gespeichert
taxpool.print_log(filename)
return 
end

-- zaehler f.d. importierten zeilen
local counter=0

-- zaehler f.d. haupt-splittbuchungen
local groupcounter=1

-- Indikator f.d. Splitt-Buchungs-Typ: 1: haupt-splittbuchung, >1: sub-splittbuchung
local splitcounter=1

-- konto d. haupt-splittbuchungen
local splittkonto=0
-- buchungstext d. haupt-splittbuchungen
local splittbuchungstext="";

local file, file_error = io.open(filename, "r")
if not file then
taxpool.message_box("Die Datei\n'"..filename.."'\nkonnte nicht geöffnet werden.\n"..file_error, taxpool.DLG_OK|taxpool.DLG_INFO)
return
end

for line in file:lines() do

	--Feldnamen überspringen, sofern vorhanden
	if counter>0 or not has_fieldnames then

		if not is_utf8 then
		line=taxpool.to_utf8(line) 
		end

		--taxpool.print_log(line)

		local t=taxpool.tokenize(line, delim)
		-- Die Feldnamen sind frei wählbar, die Struktur der Datei muss bekannt sein
		local Belegdatum, Buchungstext, Belegnummer, Brutto, Steuersatz, Sollkonto, Habenkonto, Kostenstelle1, Kostenstelle2
		=table.unpack(t)

		-- Neue Buchung erzeugen
		local buchung=taxpool.add_booking_entry()
		taxpool.set_booking_entry_field(buchung, 
						taxpool.BEF_BELEGDATUM, Belegdatum,
						taxpool.BEF_BUCHUNGSTEXT, Buchungstext,
						taxpool.BEF_BRUTTO, Brutto,
						taxpool.BEF_SOLLKONTO, Sollkonto,
						taxpool.BEF_HABENKONTO, Habenkonto,
						taxpool.BEF_KOSTENSTELLE_1, Kostenstelle1,
						taxpool.BEF_KOSTENSTELLE_2, Kostenstelle2
						)
						
		
		--ANFANG BELEGKREIS SETZEN
		--Namen des Belegkreises extrahieren
		local belegkreis=str.find_regex(Belegnummer, "([a-zA-ZäöüÄÖÜß]+)", str.REGEX_RET_MATCH|str.REGEX_RET_AS_STRING)
		--Zahlenwert der Belegnummer extrahieren
		local belegzahl=str.find_regex(Belegnummer, "\\d+", str.REGEX_RET_MATCH|str.REGEX_RET_AS_STRING)
		
		if str.length(belegkreis)>0 then
			--Neuen Belegkreis anlegen, falls nicht vorhanden
			if not taxpool.find_voucher_category(belegkreis) then
			taxpool.add_voucher_entry(-1, "", belegkreis) --kontonummer, datum, titel
			end
			
			taxpool.set_booking_entry_field(buchung, taxpool.BEF_BELEGNUMMERN_KREIS, belegkreis)
			--Zaehler aus der Importdatei benutzen, ansonsten wird automatisch die naechste Nummer vergeben, siehe dazu in der Hilfe
			--taxpool.set_booking_entry_field(buchung, taxpool.BEF_BELEGNUMMERN_ZAEHLER, belegzahl)
		end
		--ENDE BELEGKREIS SETZEN
		

		local bDel=false
		-- ANFANG PRUEFUNG AUF SPLITT-BUCHUNG
		local sollinvalid=tonumber(Sollkonto)==nil or tonumber(Sollkonto)<=0
		local habeninvalid=tonumber(Habenkonto)==nil or tonumber(Habenkonto)<=0
					
		if sollinvalid or habeninvalid then
			
			if splitcounter>1 then -- Sub-Splitt
				--Das Gegenkonto zuweisen, die Werte werden aus der vorhergehenden Haupt-Splitt-Buchung ermittelt, s.u.
				if sollinvalid then
				taxpool.print_log("Setze Splitt-Soll in Sub-Splitt: "..splittkonto)
				Sollkonto=splittkonto
				taxpool.set_booking_entry_field(buchung, taxpool.BEF_SOLLKONTO, Sollkonto)
				else 
				taxpool.print_log("Setze Splitt-Haben in Sub-Splitt: "..splittkonto)
				Habenkonto=splittkonto
				taxpool.set_booking_entry_field(buchung, taxpool.BEF_HABENKONTO, Habenkonto)
				end
				--Splitt erzeugen
				taxpool.create_booking_entry_split(buchung, groupcounter, splittbuchungstext)
				
			else -- Haupt-Splitt
			taxpool.print_log("Haupt-Splitt gefunden: "..line)
			splittbuchungstext=Buchungstext
			splitcounter=splitcounter+1
			groupcounter=groupcounter+1
			
				if sollinvalid then
				splittkonto=Habenkonto
				else 
				splittkonto=Sollkonto
				end
			
			-- Die Haupt-Splitt-Buchung wird nicht mehr benötigt
			taxpool.booking_entry_edit_action(buchung, taxpool.MODUS_LOESCHEN)
			bDel=true
			end

		else
		-- zaehler zuruecksetzen
		splitcounter=1
		end
		-- ENDE PRUEFUNG AUF SPLITT-BUCHUNG
				
		--Evtl. Steuersatz setzen, falls nicht die Standard-Steuersaetze der Konten benutzt werden sollen
		if not bDel then
		local taxid=taxpool.calc_tax_id(Sollkonto, Habenkonto, Belegdatum, Steuersatz, "")
		taxpool.set_booking_entry_field(buchung, taxpool.BEF_STEUERSATZ_ID, taxid)
		end

	end --Ende Feldnamen ueberspringen

counter=counter+1
end -- Ende for-Schleife

taxpool.end_transaction(1,1)

