--[[
Dies ist ein Beispielskript zum Exportieren von Buchungsdaten in eine Textdatei.
]]

if taxpool.message_box("Bei diesem Beispiel werden Daten in eine Textdatei exportiert.\nWollen Sie den Vorgang wirklich fortsetzen?", 
					   taxpool.DLG_YES|taxpool.DLG_NO|taxpool.DLG_QUESTION)==taxpool.DLG_NO then
return
end

local filename=taxpool.get_script_dir().."test-export1.txt"

local file, file_error = io.open(filename, "w+")
if not file then
taxpool.message_box("Die Datei\n'"..filename.."'\nkonnte nicht geöffnet werden.\n"..file_error, taxpool.DLG_OK, taxpool.DLG_INFO)
return
end

taxpool.start_transaction(1)

--Alle Buchungen im Stapel von 2014, ausgenommen Splitt-Buchungen und ungueltige Buchungen 
local t=taxpool.get_bookings(0, "1.1.2024", "31.12.2024", taxpool.BES_STAPEL, taxpool.BES_NONE, taxpool.BES_UNGUELTIG, taxpool.BES_NONE, "", "", true)
taxpool.print_log(#t.." Datensaetze")  

if #t >0 then
-- Feld-Titel schreiben
file : write("DATUM;BRUTTO;BUCHUNGSTEXT;BELEG;SOLLKONTO;HABENKONTO\n")
end

for i=1,#t do
local res, datum, brutto, bt, beleg, soll, haben
	  =taxpool.get_booking_entry_field(t[i], taxpool.BEF_BELEGDATUM, taxpool.AS_STRING,
													  taxpool.BEF_BRUTTO, taxpool.AS_STRING|taxpool.LOCALE|taxpool.DECIMAL_SEPARATOR, 
													  taxpool.BEF_BUCHUNGSTEXT, taxpool.AS_STRING, 
													  taxpool.BEF_BELEG, taxpool.AS_STRING, 
													  taxpool.BEF_SOLLKONTO, taxpool.AS_STRING, 
													  taxpool.BEF_HABENKONTO, taxpool.AS_STRING					  
													  )
	if res then
		taxpool.print_log("Belegdatum="..datum) 
		file : write(datum..";"..brutto..";"..bt..";"..beleg..";"..soll..";"..haben) 
		if i~=#t then
		file : write("\n")
		end
	end
end

file:close()

--Datei anzeigen
--os.execute("notepad.exe '"..filename.."'") 

taxpool.end_transaction(1,0)
