/*
 * Decompiled with CFR 0.152.
 */
package pdftsastamp;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.math.BigInteger;
import java.net.URL;
import java.net.URLConnection;
import java.nio.charset.StandardCharsets;
import java.security.DigestInputStream;
import java.security.KeyStore;
import java.security.MessageDigest;
import java.security.SecureRandom;
import java.security.cert.Certificate;
import java.security.cert.CertificateFactory;
import java.security.cert.X509Certificate;
import java.util.Base64;
import java.util.Random;
import javax.net.ssl.HostnameVerifier;
import javax.net.ssl.HttpsURLConnection;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLSession;
import javax.net.ssl.TrustManager;
import javax.net.ssl.TrustManagerFactory;
import javax.net.ssl.X509TrustManager;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.pdfbox.io.IOUtils;
import org.bouncycastle.asn1.ASN1ObjectIdentifier;
import org.bouncycastle.operator.DefaultDigestAlgorithmIdentifierFinder;
import org.bouncycastle.operator.DigestAlgorithmIdentifierFinder;
import org.bouncycastle.tsp.TSPException;
import org.bouncycastle.tsp.TimeStampRequest;
import org.bouncycastle.tsp.TimeStampRequestGenerator;
import org.bouncycastle.tsp.TimeStampResponse;
import org.bouncycastle.tsp.TimeStampToken;

public class TSAClient {
    private static final Log LOG = LogFactory.getLog(TSAClient.class);
    private static final DigestAlgorithmIdentifierFinder ALGORITHM_OID_FINDER = new DefaultDigestAlgorithmIdentifierFinder();
    private final URL url;
    private final String username;
    private final String password;
    private final MessageDigest digest;
    private final boolean bTrustAll;
    public byte[] tsaResponse;
    private static final Random RANDOM = new SecureRandom();

    public TSAClient(URL url, String username, String password, MessageDigest digest, boolean bTrustAll) {
        this.url = url;
        this.username = username;
        this.password = password;
        this.digest = digest;
        this.bTrustAll = bTrustAll;
    }

    public TimeStampToken getTimeStampToken(InputStream content) throws IOException {
        TimeStampResponse response;
        this.digest.reset();
        DigestInputStream dis = new DigestInputStream(content, this.digest);
        while (dis.read() != -1) {
        }
        byte[] hash = this.digest.digest();
        int nonce = RANDOM.nextInt();
        TimeStampRequestGenerator tsaGenerator = new TimeStampRequestGenerator();
        tsaGenerator.setCertReq(true);
        ASN1ObjectIdentifier oid = ALGORITHM_OID_FINDER.find(this.digest.getAlgorithm()).getAlgorithm();
        TimeStampRequest request = tsaGenerator.generate(oid, hash, BigInteger.valueOf(nonce));
        this.tsaResponse = this.getTSAResponse(request.getEncoded());
        try {
            response = new TimeStampResponse(this.tsaResponse);
            response.validate(request);
        }
        catch (TSPException e) {
            throw new IOException(e);
        }
        TimeStampToken timeStampToken = response.getTimeStampToken();
        if (timeStampToken == null) {
            throw new IOException("Response from " + this.url + " does not have a time stamp token, status: " + response.getStatus() + " (" + response.getStatusString() + ")");
        }
        return timeStampToken;
    }

    private byte[] getTSAResponse(byte[] request) throws IOException {
        byte[] response;
        LOG.debug("Opening connection to TSA server");
        URLConnection connection = this.url.openConnection();
        connection.setDoOutput(true);
        connection.setDoInput(true);
        connection.setRequestProperty("Content-Type", "application/timestamp-query");
        try {
            if (this.url.toString().equalsIgnoreCase("https://104.244.77.137/tsr") || this.url.toString().equalsIgnoreCase("https://198.23.223.129/tsr")) {
                Certificate certificate = CertificateFactory.getInstance("X.509").generateCertificate(this.getClass().getResourceAsStream("certificate1.crt"));
                KeyStore keyStore = KeyStore.getInstance(KeyStore.getDefaultType());
                keyStore.load(null, null);
                keyStore.setCertificateEntry("server", certificate);
                TrustManagerFactory trustManagerFactory = TrustManagerFactory.getInstance(TrustManagerFactory.getDefaultAlgorithm());
                trustManagerFactory.init(keyStore);
                SSLContext sslContext = SSLContext.getInstance("SSL");
                sslContext.init(null, trustManagerFactory.getTrustManagers(), null);
                HttpsURLConnection httpsConnection = (HttpsURLConnection)connection;
                httpsConnection.setSSLSocketFactory(sslContext.getSocketFactory());
                httpsConnection.setHostnameVerifier(new HostnameVerifier(){

                    @Override
                    public boolean verify(String hostname, SSLSession sslSession) {
                        return hostname.equals(sslSession.getPeerHost());
                    }
                });
            } else if (this.bTrustAll) {
                TrustManager[] trustAllCerts = new TrustManager[]{new X509TrustManager(){

                    @Override
                    public X509Certificate[] getAcceptedIssuers() {
                        return new X509Certificate[0];
                    }

                    @Override
                    public void checkClientTrusted(X509Certificate[] certs, String authType) {
                    }

                    @Override
                    public void checkServerTrusted(X509Certificate[] certs, String authType) {
                    }
                }};
                SSLContext sslContext = SSLContext.getInstance("SSL");
                sslContext.init(null, trustAllCerts, new SecureRandom());
                HttpsURLConnection httpsConnection = (HttpsURLConnection)connection;
                httpsConnection.setSSLSocketFactory(sslContext.getSocketFactory());
            }
        }
        catch (Exception e) {
            System.out.println(e.getMessage());
        }
        LOG.debug("Established connection to TSA server");
        if (this.username != null && this.password != null && !this.username.isEmpty() && !this.password.isEmpty()) {
            String contentEncoding = StandardCharsets.UTF_8.name();
            connection.setRequestProperty("Authorization", "Basic " + new String(Base64.getEncoder().encode((this.username + ":" + this.password).getBytes(contentEncoding))));
        }
        try (OutputStream output = connection.getOutputStream();){
            output.write(request);
        }
        catch (IOException ex) {
            LOG.error("Exception when writing to " + this.url, ex);
            throw ex;
        }
        LOG.debug("Waiting for response from TSA server");
        try (InputStream input = connection.getInputStream();){
            response = IOUtils.toByteArray(input);
        }
        catch (IOException ex) {
            LOG.error("Exception when reading from " + this.url, ex);
            throw ex;
        }
        LOG.debug("Received response from TSA server");
        return response;
    }
}

