/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pdfbox.tools;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.io.PrintStream;
import java.io.Reader;
import java.util.concurrent.Callable;
import org.apache.pdfbox.pdmodel.PDDocument;
import org.apache.pdfbox.pdmodel.PDPage;
import org.apache.pdfbox.pdmodel.PDPageContentStream;
import org.apache.pdfbox.pdmodel.common.PDRectangle;
import org.apache.pdfbox.pdmodel.font.PDFont;
import org.apache.pdfbox.pdmodel.font.PDType0Font;
import org.apache.pdfbox.pdmodel.font.PDType1Font;
import org.apache.pdfbox.tools.Version;
import picocli.CommandLine;

@CommandLine.Command(name="texttopdf", header={"Creates a PDF document from text"}, versionProvider=Version.class, mixinStandardHelpOptions=true)
public class TextToPDF
implements Callable<Integer> {
    private static final int FONTSCALE = 1000;
    private static final int DEFAULT_FONT_SIZE = 10;
    private static final float LINE_HEIGHT_FACTOR = 1.05f;
    private PDRectangle mediaBox = PDRectangle.LETTER;
    private PDFont font = Standard14Fonts.HELVETICA.getFont();
    private static final PrintStream SYSERR = System.err;
    @CommandLine.Option(names={"-fontSize"}, description={"the size of the font to use (default: ${DEFAULT-VALUE}"})
    private int fontSize = 10;
    @CommandLine.Option(names={"-landscape"}, description={"set orientation to landscape"})
    private boolean landscape = false;
    @CommandLine.Option(names={"-pageSize"}, description={"the page size to use. \nCandidates: ${COMPLETION-CANDIDATES} (default: ${DEFAULT-VALUE})"})
    private PageSizes pageSize = PageSizes.LETTER;
    @CommandLine.Option(names={"-standardFont"}, description={"the font to use for the text. Either this or -ttf should be specified but not both.\nCandidates: ${COMPLETION-CANDIDATES} (default: ${DEFAULT-VALUE})"})
    private Standard14Fonts standardFont = Standard14Fonts.HELVETICA;
    @CommandLine.Option(names={"-ttf"}, paramLabel="<ttf file>", description={"the TTF font to use for the text. Either this or -standardFont should be specified but not both."})
    private File ttf;
    @CommandLine.Option(names={"-i", "--input"}, description={"the text file to convert"}, required=true)
    private File infile;
    @CommandLine.Option(names={"-o", "--output"}, description={"the generated PDF file"}, required=true)
    private File outfile;

    public static void main(String[] args) {
        System.setProperty("apple.awt.UIElement", "true");
        int exitCode = new CommandLine(new TextToPDF()).execute(args);
        System.exit(exitCode);
    }

    @Override
    public Integer call() {
        try (PDDocument doc = new PDDocument();){
            this.font = this.ttf != null ? PDType0Font.load(doc, this.ttf) : this.standardFont.getFont();
            this.setFont(this.font);
            this.setFontSize(this.fontSize);
            this.setMediaBox(this.pageSize.getPageSize());
            this.setLandscape(this.landscape);
            try (FileReader fileReader = new FileReader(this.infile);){
                this.createPDFFromText(doc, fileReader);
            }
            doc.save(this.outfile);
        }
        catch (IOException ioe) {
            SYSERR.println("Error converting text to PDF [" + ioe.getClass().getSimpleName() + "]: " + ioe.getMessage());
            return 4;
        }
        return 0;
    }

    public PDDocument createPDFFromText(Reader text) throws IOException {
        PDDocument doc = new PDDocument();
        this.createPDFFromText(doc, text);
        return doc;
    }

    public void createPDFFromText(PDDocument doc, Reader text) throws IOException {
        try {
            String nextLine;
            int margin = 40;
            float height = this.font.getBoundingBox().getHeight() / 1000.0f;
            PDRectangle actualMediaBox = this.mediaBox;
            if (this.landscape) {
                actualMediaBox = new PDRectangle(this.mediaBox.getHeight(), this.mediaBox.getWidth());
            }
            height = height * (float)this.fontSize * 1.05f;
            BufferedReader data = new BufferedReader(text);
            PDPage page = new PDPage(actualMediaBox);
            PDPageContentStream contentStream = null;
            float y = -1.0f;
            float maxStringLength = page.getMediaBox().getWidth() - 80.0f;
            boolean textIsEmpty = true;
            while ((nextLine = data.readLine()) != null) {
                textIsEmpty = false;
                String[] lineWords = nextLine.replaceAll("[\\n\\r]+$", "").split(" ");
                int lineIndex = 0;
                while (lineIndex < lineWords.length) {
                    StringBuilder nextLineToDraw = new StringBuilder();
                    float lengthIfUsingNextWord = 0.0f;
                    boolean ff = false;
                    do {
                        String word1;
                        String word2 = "";
                        int indexFF = lineWords[lineIndex].indexOf(12);
                        if (indexFF == -1) {
                            word1 = lineWords[lineIndex];
                        } else {
                            ff = true;
                            word1 = lineWords[lineIndex].substring(0, indexFF);
                            if (indexFF < lineWords[lineIndex].length()) {
                                word2 = lineWords[lineIndex].substring(indexFF + 1);
                            }
                        }
                        if (word1.length() > 0 || !ff) {
                            nextLineToDraw.append(word1);
                            nextLineToDraw.append(" ");
                        }
                        if (!ff || word2.length() == 0) {
                            ++lineIndex;
                        } else {
                            lineWords[lineIndex] = word2;
                        }
                        if (ff) break;
                        if (lineIndex >= lineWords.length) continue;
                        String nextWord = lineWords[lineIndex];
                        indexFF = nextWord.indexOf(12);
                        if (indexFF != -1) {
                            nextWord = nextWord.substring(0, indexFF);
                        }
                        String lineWithNextWord = nextLineToDraw.toString() + " " + nextWord;
                        lengthIfUsingNextWord = this.font.getStringWidth(lineWithNextWord) / 1000.0f * (float)this.fontSize;
                    } while (lineIndex < lineWords.length && lengthIfUsingNextWord < maxStringLength);
                    if (y < 40.0f) {
                        page = new PDPage(actualMediaBox);
                        doc.addPage(page);
                        if (contentStream != null) {
                            contentStream.endText();
                            contentStream.close();
                        }
                        contentStream = new PDPageContentStream(doc, page);
                        contentStream.setFont(this.font, this.fontSize);
                        contentStream.beginText();
                        y = page.getMediaBox().getHeight() - 40.0f + height;
                        contentStream.newLineAtOffset(40.0f, y);
                    }
                    if (contentStream == null) {
                        throw new IOException("Error:Expected non-null content stream.");
                    }
                    contentStream.newLineAtOffset(0.0f, -height);
                    y -= height;
                    contentStream.showText(nextLineToDraw.toString());
                    if (!ff) continue;
                    page = new PDPage(actualMediaBox);
                    doc.addPage(page);
                    contentStream.endText();
                    contentStream.close();
                    contentStream = new PDPageContentStream(doc, page);
                    contentStream.setFont(this.font, this.fontSize);
                    contentStream.beginText();
                    y = page.getMediaBox().getHeight() - 40.0f + height;
                    contentStream.newLineAtOffset(40.0f, y);
                }
            }
            if (textIsEmpty) {
                doc.addPage(page);
            }
            if (contentStream != null) {
                contentStream.endText();
                contentStream.close();
            }
        }
        catch (IOException io) {
            if (doc != null) {
                doc.close();
            }
            throw io;
        }
    }

    public PDFont getFont() {
        return this.font;
    }

    public void setFont(PDFont aFont) {
        this.font = aFont;
    }

    public int getFontSize() {
        return this.fontSize;
    }

    public void setFontSize(int aFontSize) {
        this.fontSize = aFontSize;
    }

    public PDRectangle getMediaBox() {
        return this.mediaBox;
    }

    public void setMediaBox(PDRectangle mediaBox) {
        this.mediaBox = mediaBox;
    }

    public boolean isLandscape() {
        return this.landscape;
    }

    public void setLandscape(boolean landscape) {
        this.landscape = landscape;
    }

    private static enum Standard14Fonts {
        TIMES_ROMAN(PDType1Font.TIMES_ROMAN.getBaseFont(), PDType1Font.TIMES_ROMAN),
        TIMES_BOLD(PDType1Font.TIMES_BOLD.getBaseFont(), PDType1Font.TIMES_BOLD),
        TIMES_ITALIC(PDType1Font.TIMES_ITALIC.getBaseFont(), PDType1Font.TIMES_ITALIC),
        TIMES_BOLD_ITALIC(PDType1Font.TIMES_BOLD_ITALIC.getBaseFont(), PDType1Font.TIMES_BOLD_ITALIC),
        HELVETICA(PDType1Font.HELVETICA.getBaseFont(), PDType1Font.HELVETICA),
        HELVETICA_BOLD(PDType1Font.HELVETICA_BOLD.getBaseFont(), PDType1Font.HELVETICA_BOLD),
        HELVETICA_OBLIQUE(PDType1Font.HELVETICA_OBLIQUE.getBaseFont(), PDType1Font.HELVETICA_OBLIQUE),
        HELVETICA_BOLD_OBLIQUE(PDType1Font.HELVETICA_BOLD_OBLIQUE.getBaseFont(), PDType1Font.HELVETICA_BOLD_OBLIQUE),
        COURIER(PDType1Font.COURIER.getBaseFont(), PDType1Font.COURIER),
        COURIER_BOLD(PDType1Font.COURIER_BOLD.getBaseFont(), PDType1Font.COURIER_BOLD),
        COURIER_OBLIQUE(PDType1Font.COURIER_OBLIQUE.getBaseFont(), PDType1Font.COURIER_OBLIQUE),
        COURIER_BOLD_OBLIQUE(PDType1Font.COURIER_BOLD_OBLIQUE.getBaseFont(), PDType1Font.COURIER_BOLD_OBLIQUE),
        SYMBOL(PDType1Font.SYMBOL.getBaseFont(), PDType1Font.SYMBOL),
        ZAPF_DINGBATS(PDType1Font.ZAPF_DINGBATS.getBaseFont(), PDType1Font.ZAPF_DINGBATS);

        final String displayName;
        final PDFont font;

        private Standard14Fonts(String displayName, PDFont font) {
            this.displayName = displayName;
            this.font = font;
        }

        public PDFont getFont() {
            return this.font;
        }

        public String toString() {
            return this.displayName;
        }
    }

    private static enum PageSizes {
        LETTER(PDRectangle.LETTER),
        LEGAL(PDRectangle.LEGAL),
        A0(PDRectangle.A0),
        A1(PDRectangle.A1),
        A2(PDRectangle.A2),
        A3(PDRectangle.A3),
        A4(PDRectangle.A4),
        A5(PDRectangle.A5),
        A6(PDRectangle.A6);

        final PDRectangle pageSize;

        private PageSizes(PDRectangle pageSize) {
            this.pageSize = pageSize;
        }

        public PDRectangle getPageSize() {
            return this.pageSize;
        }
    }
}

