/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pdfbox.pdfwriter.compress;

import java.util.ArrayList;
import java.util.List;
import org.apache.pdfbox.cos.COSBase;
import org.apache.pdfbox.cos.COSObject;
import org.apache.pdfbox.cos.COSStream;

public class TraversedCOSElement {
    private final TraversedCOSElement parent;
    private final COSBase currentObject;
    private final List<TraversedCOSElement> traversedChildren = new ArrayList<TraversedCOSElement>();
    private boolean partOfStreamDictionary = false;
    private final List<COSBase> allObjects;

    public TraversedCOSElement(COSBase currentObject) {
        this(new ArrayList<COSBase>(), null, currentObject);
    }

    private TraversedCOSElement(List<COSBase> allObjects, TraversedCOSElement parent, COSBase currentObject) {
        this.parent = parent;
        this.currentObject = currentObject;
        this.allObjects = allObjects;
    }

    public TraversedCOSElement appendTraversedElement(COSBase element) {
        if (element == null) {
            return this;
        }
        this.allObjects.add(element);
        TraversedCOSElement traversedElement = new TraversedCOSElement(this.allObjects, this, element);
        traversedElement.setPartOfStreamDictionary(this.isPartOfStreamDictionary() || this.getCurrentBaseObject() instanceof COSStream);
        this.traversedChildren.add(traversedElement);
        return traversedElement;
    }

    public COSBase getCurrentObject() {
        return this.currentObject;
    }

    public COSBase getCurrentBaseObject() {
        return this.currentObject instanceof COSObject ? ((COSObject)this.currentObject).getObject() : this.currentObject;
    }

    public TraversedCOSElement getParent() {
        return this.parent;
    }

    public List<TraversedCOSElement> getTraversedChildren() {
        return this.traversedChildren;
    }

    public List<TraversedCOSElement> getTraversedElements() {
        List<Object> ancestry = this.parent == null ? new ArrayList() : this.parent.getTraversedElements();
        ancestry.add(this);
        return ancestry;
    }

    public TraversedCOSElement findAtCurrentPosition(COSBase object) {
        for (TraversedCOSElement child : this.traversedChildren) {
            if (child.getCurrentObject() != object) continue;
            return child;
        }
        return null;
    }

    public List<COSBase> getAllTraversedObjects() {
        return this.allObjects;
    }

    public boolean isPartOfStreamDictionary() {
        return this.partOfStreamDictionary;
    }

    public void setPartOfStreamDictionary(boolean partOfStreamDictionary) {
        this.partOfStreamDictionary = partOfStreamDictionary;
    }
}

