/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pdfbox.examples.pdmodel;

import java.io.IOException;
import org.apache.pdfbox.pdmodel.PDDocument;
import org.apache.pdfbox.pdmodel.PDPage;
import org.apache.pdfbox.pdmodel.PDPageContentStream;
import org.apache.pdfbox.pdmodel.common.PDRectangle;
import org.apache.pdfbox.pdmodel.font.PDFont;
import org.apache.pdfbox.pdmodel.font.PDType1Font;
import org.apache.pdfbox.util.Matrix;

public class UsingTextMatrix {
    public void doIt(String message, String outfile) throws IOException {
        try (PDDocument doc = new PDDocument();){
            int i;
            PDType1Font font = PDType1Font.HELVETICA;
            PDPage page = new PDPage(PDRectangle.A4);
            doc.addPage(page);
            float fontSize = 12.0f;
            PDRectangle pageSize = page.getMediaBox();
            float centeredXPosition = (pageSize.getWidth() - fontSize / 1000.0f) / 2.0f;
            float stringWidth = font.getStringWidth(message);
            float centeredYPosition = (pageSize.getHeight() - stringWidth * fontSize / 1000.0f) / 3.0f;
            PDPageContentStream contentStream = new PDPageContentStream(doc, page, PDPageContentStream.AppendMode.OVERWRITE, false);
            contentStream.setFont((PDFont)font, fontSize);
            contentStream.beginText();
            for (i = 0; i < 8; ++i) {
                contentStream.setTextMatrix(Matrix.getRotateInstance((double)((double)i * Math.PI * 0.25), (float)centeredXPosition, (float)(pageSize.getHeight() - centeredYPosition)));
                contentStream.showText(message + " " + i);
            }
            for (i = 0; i < 8; ++i) {
                contentStream.setTextMatrix(Matrix.getRotateInstance((double)((double)(-i) * Math.PI * 0.25), (float)centeredXPosition, (float)centeredYPosition));
                contentStream.showText(message + " " + i);
            }
            contentStream.endText();
            contentStream.close();
            page = new PDPage(PDRectangle.A4);
            doc.addPage(page);
            fontSize = 1.0f;
            contentStream = new PDPageContentStream(doc, page, PDPageContentStream.AppendMode.OVERWRITE, false);
            contentStream.setFont((PDFont)font, fontSize);
            contentStream.beginText();
            for (i = 0; i < 10; ++i) {
                contentStream.setTextMatrix(new Matrix(12.0f + (float)(i * 6), 0.0f, 0.0f, 12.0f + (float)(i * 6), 100.0f, 100.0f + (float)(i * 50)));
                contentStream.showText(message + " " + i);
            }
            contentStream.endText();
            contentStream.close();
            page = new PDPage(PDRectangle.A4);
            doc.addPage(page);
            fontSize = 1.0f;
            contentStream = new PDPageContentStream(doc, page, PDPageContentStream.AppendMode.OVERWRITE, false);
            contentStream.setFont((PDFont)font, fontSize);
            contentStream.beginText();
            i = 0;
            contentStream.setTextMatrix(new Matrix(12.0f, 0.0f, 0.0f, 12.0f, centeredXPosition, centeredYPosition * 1.5f));
            contentStream.showText(message + " " + i++);
            contentStream.setTextMatrix(new Matrix(0.0f, 18.0f, -18.0f, 0.0f, centeredXPosition, centeredYPosition * 1.5f));
            contentStream.showText(message + " " + i++);
            contentStream.setTextMatrix(new Matrix(-24.0f, 0.0f, 0.0f, -24.0f, centeredXPosition, centeredYPosition * 1.5f));
            contentStream.showText(message + " " + i++);
            contentStream.setTextMatrix(new Matrix(0.0f, -30.0f, 30.0f, 0.0f, centeredXPosition, centeredYPosition * 1.5f));
            contentStream.showText(message + " " + i++);
            contentStream.endText();
            contentStream.close();
            doc.save(outfile);
        }
    }

    public static void main(String[] args) throws IOException {
        UsingTextMatrix app = new UsingTextMatrix();
        if (args.length != 2) {
            app.usage();
        } else {
            app.doIt(args[0], args[1]);
        }
    }

    private void usage() {
        System.err.println("usage: " + this.getClass().getName() + " <Message> <output-file>");
    }
}

