/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pdfbox.examples.lucene;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.io.StringReader;
import java.io.StringWriter;
import java.io.Writer;
import java.net.URL;
import java.net.URLConnection;
import java.util.Calendar;
import java.util.Date;
import org.apache.lucene.document.DateTools;
import org.apache.lucene.document.Document;
import org.apache.lucene.document.Field;
import org.apache.lucene.document.FieldType;
import org.apache.lucene.document.StringField;
import org.apache.lucene.document.TextField;
import org.apache.lucene.index.IndexOptions;
import org.apache.lucene.index.IndexableField;
import org.apache.lucene.index.IndexableFieldType;
import org.apache.pdfbox.Loader;
import org.apache.pdfbox.pdmodel.PDDocument;
import org.apache.pdfbox.pdmodel.PDDocumentInformation;
import org.apache.pdfbox.pdmodel.encryption.InvalidPasswordException;
import org.apache.pdfbox.text.PDFTextStripper;

public class LucenePDFDocument {
    private static final char FILE_SEPARATOR = System.getProperty("file.separator").charAt(0);
    private static final DateTools.Resolution DATE_TIME_RES = DateTools.Resolution.SECOND;
    private PDFTextStripper stripper = null;
    public static final FieldType TYPE_STORED_NOT_INDEXED = new FieldType();

    public void setTextStripper(PDFTextStripper aStripper) {
        this.stripper = aStripper;
    }

    private static String timeToString(long time) {
        return DateTools.timeToString((long)time, (DateTools.Resolution)DATE_TIME_RES);
    }

    private void addKeywordField(Document document, String name, String value) {
        if (value != null) {
            document.add((IndexableField)new StringField(name, value, Field.Store.YES));
        }
    }

    private void addTextField(Document document, String name, Reader value) {
        if (value != null) {
            document.add((IndexableField)new TextField(name, value));
        }
    }

    private void addTextField(Document document, String name, String value) {
        if (value != null) {
            document.add((IndexableField)new TextField(name, value, Field.Store.YES));
        }
    }

    private void addTextField(Document document, String name, Date value) {
        if (value != null) {
            this.addTextField(document, name, DateTools.dateToString((Date)value, (DateTools.Resolution)DATE_TIME_RES));
        }
    }

    private void addTextField(Document document, String name, Calendar value) {
        if (value != null) {
            this.addTextField(document, name, value.getTime());
        }
    }

    private static void addUnindexedField(Document document, String name, String value) {
        if (value != null) {
            document.add((IndexableField)new Field(name, (CharSequence)value, (IndexableFieldType)TYPE_STORED_NOT_INDEXED));
        }
    }

    private void addUnstoredKeywordField(Document document, String name, String value) {
        if (value != null) {
            document.add((IndexableField)new Field(name, (CharSequence)value, (IndexableFieldType)TextField.TYPE_NOT_STORED));
        }
    }

    public Document convertDocument(InputStream is) throws IOException {
        Document document = new Document();
        this.addContent(document, is, "<inputstream>");
        return document;
    }

    public Document convertDocument(File file) throws IOException {
        Document document = new Document();
        LucenePDFDocument.addUnindexedField(document, "path", file.getPath());
        LucenePDFDocument.addUnindexedField(document, "url", file.getPath().replace(FILE_SEPARATOR, '/'));
        this.addKeywordField(document, "modified", LucenePDFDocument.timeToString(file.lastModified()));
        String uid = LucenePDFDocument.createUID(file);
        this.addUnstoredKeywordField(document, "uid", uid);
        try (FileInputStream input = new FileInputStream(file);){
            this.addContent(document, input, file.getPath());
        }
        return document;
    }

    public Document convertDocument(URL url) throws IOException {
        Document document = new Document();
        URLConnection connection = url.openConnection();
        connection.connect();
        LucenePDFDocument.addUnindexedField(document, "url", url.toExternalForm());
        this.addKeywordField(document, "modified", LucenePDFDocument.timeToString(connection.getLastModified()));
        String uid = LucenePDFDocument.createUID(url, connection.getLastModified());
        this.addUnstoredKeywordField(document, "uid", uid);
        try (InputStream input = connection.getInputStream();){
            this.addContent(document, input, url.toExternalForm());
        }
        return document;
    }

    public static Document getDocument(InputStream is) throws IOException {
        LucenePDFDocument converter = new LucenePDFDocument();
        return converter.convertDocument(is);
    }

    public static Document getDocument(File file) throws IOException {
        LucenePDFDocument converter = new LucenePDFDocument();
        return converter.convertDocument(file);
    }

    public static Document getDocument(URL url) throws IOException {
        LucenePDFDocument converter = new LucenePDFDocument();
        return converter.convertDocument(url);
    }

    private void addContent(Document document, InputStream is, String documentLocation) throws IOException {
        try (PDDocument pdfDocument = Loader.loadPDF((InputStream)is);){
            StringWriter writer = new StringWriter();
            if (this.stripper == null) {
                this.stripper = new PDFTextStripper();
            }
            this.stripper.writeText(pdfDocument, (Writer)writer);
            String contents = writer.getBuffer().toString();
            StringReader reader = new StringReader(contents);
            this.addTextField(document, "contents", reader);
            PDDocumentInformation info = pdfDocument.getDocumentInformation();
            if (info != null) {
                this.addTextField(document, "Author", info.getAuthor());
                this.addTextField(document, "CreationDate", info.getCreationDate());
                this.addTextField(document, "Creator", info.getCreator());
                this.addTextField(document, "Keywords", info.getKeywords());
                this.addTextField(document, "ModificationDate", info.getModificationDate());
                this.addTextField(document, "Producer", info.getProducer());
                this.addTextField(document, "Subject", info.getSubject());
                this.addTextField(document, "Title", info.getTitle());
                this.addTextField(document, "Trapped", info.getTrapped());
            }
            int summarySize = Math.min(contents.length(), 500);
            String summary = contents.substring(0, summarySize);
            LucenePDFDocument.addUnindexedField(document, "summary", summary);
        }
        catch (InvalidPasswordException e) {
            throw new IOException("Error: The document(" + documentLocation + ") is encrypted and will not be indexed.", e);
        }
    }

    public static String createUID(URL url, long time) {
        return url.toExternalForm().replace(FILE_SEPARATOR, '\u0000') + "\u0000" + LucenePDFDocument.timeToString(time);
    }

    public static String createUID(File file) {
        return file.getPath().replace(FILE_SEPARATOR, '\u0000') + "\u0000" + LucenePDFDocument.timeToString(file.lastModified());
    }

    static {
        TYPE_STORED_NOT_INDEXED.setIndexOptions(IndexOptions.NONE);
        TYPE_STORED_NOT_INDEXED.setStored(true);
        TYPE_STORED_NOT_INDEXED.setTokenized(true);
        TYPE_STORED_NOT_INDEXED.freeze();
    }
}

