/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pdfbox.examples.ant;

import java.io.File;
import java.util.ArrayList;
import java.util.List;
import org.apache.pdfbox.tools.ExtractText;
import org.apache.tools.ant.Task;
import org.apache.tools.ant.types.FileSet;

public class PDFToTextTask
extends Task {
    private final List<FileSet> fileSets = new ArrayList<FileSet>();

    public void addFileset(FileSet set) {
        this.fileSets.add(set);
    }

    public void execute() {
        this.log("PDFToTextTask executing");
        this.fileSets.stream().map(fileSet -> fileSet.getDirectoryScanner(this.getProject())).forEachOrdered(dirScanner -> {
            dirScanner.scan();
            for (String file : dirScanner.getIncludedFiles()) {
                File f = new File(dirScanner.getBasedir(), file);
                this.log("processing: " + f.getAbsolutePath());
                String pdfFile = f.getAbsolutePath();
                if (!pdfFile.toUpperCase().endsWith(".PDF")) continue;
                String textFile = pdfFile.substring(0, pdfFile.length() - 3) + "txt";
                ExtractText.main((String[])new String[]{pdfFile, textFile});
            }
        });
    }
}

